local tonumber = tonumber
local negativeInfinity, positiveInfinity = -math.huge, math.huge
local torealnumber = function(value) return (negativeInfinity < value and value < positiveInfinity) and value end
local _log = math.log

LogarithmicScaler = function(min, max, rectMin, rectSize)
    -- rectMin + rectSize * log(value / min) / log(max / min)
    local A = rectMin - rectSize * _log(min) / _log(max / min)
    local M = rectSize / _log(max / min)
    return function(value, size)
        value = tonumber(value)
        if value then
            if size then
                size = tonumber(size)
                if size then
                    return torealnumber(A + M * _log(value - size / 2)), torealnumber(A + M * _log(value + size / 2))
                end
            else
                return torealnumber(A + M * _log(value))
            end
        end
    end
end

return LogarithmicScaler
